unit hs_zp3Xi;
{$N+}

Interface

uses windows, sysutils;


{*** Prft ob Zhlerkarte vorhanden ist. "0", wenn vorhanden
}
function HS_ZP3X_Initialize
(      CardNo               :longint){Nr der Karte}
:longint
; stdcall


{*** berprft die Version von Hardwaretreiber und erweiterter DLL  ***}
Function HS_ZP3X_GetVersion
(      DriverVersion: pchar;  {Version des Kartentreibers}
       DllVersion: pchar)     {Version des Basis-DLL }
:longint
; stdcall


{*** Initialisierung der Zhlerkarte / Betriebsarteneinstellung ***}
function HS_ZP3X_SetMode
(         CardNo                 :longint; {Nr der Karte}
          CounterNo              :longint; {Nr. der Achse}
          RefMode                :longint; {Initialisierungsmodus Referenz}
          StopMode               :longint) {Initialisierungsmodus Referenz}
:longint
; stdcall


{*** Setzt Multiplikator ***}
function HS_ZP3X_SetCounterMul
(     CardNo               :Longint; {Nr der Karte }
      CounterNo            :Longint; {Nr. der Achse}
      Multiplier           :Longint) {Multiplikator Achse mit CounterNo}
:longint
; stdcall


{*** Holt Zhlerwerte und Status einer Achse der Zhlerkarte ***}
function HS_ZP3X_GetCounter
(      CardNo               :longint; {Nr der Karte}
       CounterNo            :longint; {Nr der Achse}
       var Count            :longint; {Zhlerwert der Achse mit CounterNo}
       var Status           :longint) {Status der Achse mit CounterNo}
:longint
; stdcall


{*** Holt Zhlerwerte und Status aller Achsen der Zhlerkarte ***}
function HS_ZP3X_GetAllCounter
(      CardNo               :longint; {Nr der Karte}
       var Count1           :longint; {Zhlerwert der 1. Achse mit CounterNo}
       var Status1          :longint; {Status der 1. Achse mit CounterNo}
       var Count2           :longint; {Zhlerwert der 2. Achse mit CounterNo}
       var Status2          :longint; {Status der 2. Achse mit CounterNo}
       var Count3           :longint; {Zhlerwert der 3. Achse mit CounterNo}
       var Status3          :longint) {Status der 3. Achse mit CounterNo}
:longint
; stdcall


{*** Setzt Steuereingang der Zhlerkarte zurck ***}
function HS_ZP3X_ResetCounterStop
(      CardNo               :longint; {Nr der Karte}
       CounterNo            :longint) {Nr der Achse die freigegeben wird}
:longint
; stdcall



{*** Setzt die Referenz der Zhlerkarte zurck ***}
function HS_ZP3X_ResetRef
(      CardNo               :longint; {Nr der Karte}
       CounterNo            :longint) {Nr der Achse deren Referenz gelscht wird}
:longint
; stdcall


{*** Holt aktuellen Zhlerwert und Status einer Achse der Zhlerkarte ***}
function HS_ZP3X_GetCounterCurrent
(      CardNo               :longint; {Nr der Karte}
       CounterNo            :longint; {Nr der Achse}
       var Count            :longint; {Zhlerwert der Achse mit CounterNo}
       var Status           :longint) {Status der Achse mit CounterNo}
:longint
; stdcall


{*** Holt aktuelle Zhlerwerte und Status aller Achsen der Zhlerkarte ***}
function HS_ZP3X_GetAllCounterCurrent
(      CardNo               :longint; {Nr der Karte}
       var Count1           :longint; {Zhlerwert der 1. Achse mit CounterNo}
       var Status1          :longint; {Status der 1. Achse mit CounterNo}
       var Count2           :longint; {Zhlerwert der 2. Achse mit CounterNo}
       var Status2          :longint; {Status der 2. Achse mit CounterNo}
       var Count3           :longint; {Zhlerwert der 3. Achse mit CounterNo}
       var Status3          :longint) {Status der 3. Achse mit CounterNo}
:longint
; stdcall

{*** Setzt die Parameter fr abstandscodierte Mastbe ***}
function HS_ZP3X_SetDistCode
(      CardNo               :longint; {Nr der Karte}
       CounterNo            :longint; {Nr der Achse}
       Distance             :longint; {Grundabstand der Referenzmarken in mm}
       Pitch	            :longint; {Signalperiode in m}
       Offset	            :longint; {Mastabsanfang in mm}
       Direction            :longint) {Grundzhlrichtung des Mastabs}
:longint
; stdcall

{*** Stoppt alle Zhler aller Karten ***}
Function HS_ZP3X_StopAllCounter
(      CardNo               :longint) {Nr der Karte}
:longint
; stdcall





Implementation
function HS_ZP3X_Initialize;		external 'HS_ZP3X.DLL' name  'HS_ZP3X_Initialize';
Function HS_ZP3X_GetVersion;		external 'HS_ZP3X.DLL' name  'HS_ZP3X_GetVersion';
function HS_ZP3X_SetMode;		external 'HS_ZP3X.DLL' name  'HS_ZP3X_SetMode';
function HS_ZP3X_SetCounterMul;		external 'HS_ZP3X.DLL' name  'HS_ZP3X_SetCounterMul';
function HS_ZP3X_GetCounter;		external 'HS_ZP3X.DLL' name  'HS_ZP3X_GetCounter';
function HS_ZP3X_GetAllCounter;		external 'HS_ZP3X.DLL' name  'HS_ZP3X_GetAllCounter';
function HS_ZP3X_ResetCounterStop;	external 'HS_ZP3X.DLL' name  'HS_ZP3X_ResetCounterStop';
function HS_ZP3X_ResetRef;		external 'HS_ZP3X.DLL' name  'HS_ZP3X_ResetRef';
function HS_ZP3X_GetCounterCurrent;	external 'HS_ZP3X.DLL' name  'HS_ZP3X_GetCounterCurrent';
function HS_ZP3X_GetAllCounterCurrent;	external 'HS_ZP3X.DLL' name  'HS_ZP3X_GetAllCounterCurrent';
function HS_ZP3X_SetDistCode;		external 'HS_ZP3X.DLL' name  'HS_ZP3X_SetDistCode';
Function HS_ZP3X_StopAllCounter;	external 'HS_ZP3B.DLL' name  'HS_ZP3X_StopAllCounter';
begin
end.
